<?php
defined('PF_VERSION') OR exit('Access denied');
$current = isset($_GET['current']) ? (int) $_GET['current'] : '';
?>
<div class="row pull-right btnTop">
    <div class="col-md-12">
        <?php
        add_toolbar_button(form_button("<i class='fa fa-plus'></i> " . __('New Page', 'page'), array('onclick' => "window.location='" . admin_url('act=create') . "'", 'class' => 'btn btn-primary')));
        ?>
    </div>
</div><!--end button-->
<div class="hidden" id="messageErrorJS">
    <ul>
        <li class="confirmDelete"><?php echo __('Are you sure to delete this page?', 'page'); ?></li>
        <li class="notChecked"><?php echo __('No page are selected', 'page'); ?></li>
        <li class="errorSearch"><?php echo __('Please enter a search term', 'page'); ?></li>
        <li class="confirmBulkAction"><?php echo __('Are you sure to perform this action?', 'post'); ?></li>
    </ul>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-list"></i> <?php echo __('Pages', 'page'); ?></h3>
            </div>
            <div class="panel-body">
                <?php require_once ABSPATH . '/includes/common/plugin/views/alert.php'; ?>
                <div class="row margin-bottom-20">
                    <div class="col-sm-7">
                        <ul class="list-unstyled topControl">
                            <li id="bulkAction">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-default btn-sm btn-flat dropdown-toggle" data-toggle="dropdown">
                                        <?php echo __('Select Action ', 'page'); ?> <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li data-action="3"><a href="#"><?php echo __('Delete', 'page'); ?></a></li>
                                        <li data-action="1"><a href="#"><?php echo __('Publish', 'page'); ?></a></li>
                                        <li data-action="0"><a href="#"><?php echo __('Unpublish', 'page'); ?></a></li>
                                    </ul>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-5 miniSearch">
                        <div class="input-group">
                            <input type="text" class="form-control" name="kw" value="<?php echo get_value_search(); ?>" placeholder="<?php echo __('Please enter title of the page', 'page'); ?>">
                            <span class="input-group-btn">
                                <button class="btn btn-default btn-flat" type="button" id="btnMiniSearch">
                                    <i class="fa fa-search"></i> <?php echo __('Search', 'page') ?>
                                </button>
                                <a class="btn btn-default btn-flat" href="<?php echo admin_url('admin-page=page', false); ?>">
                                    <i class="fa fa-times-circle"></i>
                                </a>
                            </span>
                        </div><!-- /input-group -->
                    </div><!--end #search-->
                </div>

                <div class="row margin-bottom-10">
                    <div class="col-md-6">
                        <ul class="list-unstyled filer">
                            <li>
                                <input type="checkbox" id="checkAll"/>
                            </li>
                            <li class="filterByStatus">                        
                                <div class="btn-group">
                                    <button type="button" class="btn btn-default btn-sm btn-flat dropdown-toggle" data-toggle="dropdown">
                                        <?php printf(__('%s', 'page'), show_status_filter()); ?> <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="<?php echo admin_url('admin-page=page', false); ?>"><?php echo __('All', 'page'); ?></a></li>
                                        <li><a href="<?php echo admin_url('admin-page=page&status=1', false); ?>"><?php echo __('Published', 'page'); ?></a></li>
                                        <li><a href="<?php echo admin_url('admin-page=page&status=2', false); ?>"><?php echo __('Unpublished', 'page'); ?></a></li>
                                    </ul>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <div class="pull-right">
                            <?php echo $pagination->short_page_link(); ?>
                        </div>
                    </div>
                </div><!--end row-->

                <form method="post" role="form" action="<?php echo admin_url('&act=bulk_action'); ?>">
                    <input type="hidden" value="1" name="action"/>
                    <input type="hidden" value="<?php echo $current ?>" name="current"/>
                    <div class="row pad objectLists pages">
                        <div class="col-md-12">
                            <div class="row">
                                <?php
                                if (isset($pages) && !empty($pages)):
                                    foreach ($pages as $page):
                                        $type = $page->page_status == 1 ? 2 : 1;
                                        ?>
                                        <div class="col-md-3">
                                            <div class="row">
                                                <div class="pageItem">
                                                    <div class="col-xs-3 icon">
                                                        <p style="color: #367fa9"><i class="fa fa-file-text-o fa-3x"></i></p>
                                                        <span class="status">
                                                            <?php echo show_status(admin_url("admin-page=page&act=status&id={$page->id}&type=$type&current={$current}", false), $page->page_status); ?>
                                                        </span>
                                                    </div>
                                                    <div class="col-xs-9 name">
                                                        <h3><a href="<?php echo admin_url("admin-page=page&act=edit&id={$page->id}{$current_param}", false); ?>" title="<?php echo e($page->page_title); ?>"><?php echo e($page->page_title); ?></a></h3>
                                                        <ul class="list-unstyled actionGroup">
                                                            <li><input type="checkbox" name="id[]" class="itemCheckBox" value="<?php echo $page->id; ?>"/></li>
                                                            <li>
                                                                <a href="<?php echo admin_url("admin-page=page&act=edit&id={$page->id}{$current_param}", false); ?>" class="btn btn-info btn-xs"><i class="fa fa-edit"></i></a>
                                                                <a href="<?php echo admin_url("admin-page=page&act=delete&id={$page->id}", false); ?>" class="btn btn-danger btn-xs confirmationDelete"><i class="fa fa-trash-o"></i></a>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </div><!--end item-->
                                        <?php
                                    endforeach;
                                else:
                                    ?>
                                    <div class="col-md-12">
                                        <p class="text-center"><?php echo __('There is no page', 'page'); ?></p>
                                    </div>
                                <?php
                                endif;
                                ?>
                            </div>
                        </div>
                    </div><!--end .object Lists-->
                </form><!--end .form-->
            </div><!---end .panel-body-->
            <div class="panel-footer">
                <div class="row">
                    <div class="col-md-6">
                        <?php echo $pagination->page_lable(); ?>
                    </div>
                    <div class="col-md-6">
                        <div class="pull-right">
                            <?php echo $pagination->page_links($url . '&'); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>